---
title: 면세금액 결제방법
description: 결제 요청 시 상황에 맞게 면세 금액를 설정할 수 있는 방법을 설명합니다.
targetVersions:
  - v1
---

<div class="hint" data-style="info">

**이 문서는 [부가가치세법 제26조(재화 또는 용역의 공급에 대한 면세)](https://txsi.hometax.go.kr/docs/customer/comment/comment_jomun_main_internet.jsp?node_id=null\&lawid=001571\&jomunkey=0026005\&lawnm=%EB%B6%80%EA%B0%80%EA%B0%80%EC%B9%98%EC%84%B8%EB%B2%95\&jomun_nm=%EC%A0%9C26%EC%A1%B0%E3%80%90%EC%9E%AC%ED%99%94%20%EB%98%90%EB%8A%94%20%EC%9A%A9%EC%97%AD%EC%9D%98%20%EA%B3%B5%EA%B8%89%EC%97%90%20%EB%8C%80%ED%95%9C%20%EB%A9%B4%EC%84%B8%E3%80%91\&public_ilja=20161220\&public_no=14387)에 정해진 부가가치세(부가세) 면세상품을 판매하는 사업자에게 해당합니다.**

해당 조항에서 언급하는 재화 또는 서비스를 취급하지 않는 일반적인 사업자의 경우에는 PG사/카드사를 통해 자동으로 10% 부가세 적용이 이루어지기 때문에 아래의 내용은 참고사항으로 알아두셔도 됩니다.

</div>

## PG 계약 시 상점아이디 설정하기 <a href="#pg" id="pg" />

**부가세 면세 사업자의 경우** PG 계약 시 면세 사업자임을 밝히고 사업자등록증을 제출하면 면세 금액를 설정할 수 있는 상점아이디를 발급받을 수 있습니다.
`IMP.`**`request_pay`** 함수로 결제창을 호출할 때 다음 속성들을 사용하여 면세 금액를 적용할 수 있습니다.

- **`amount`**: 총 결제금액
- **`tax_free`**: 총 면세상품의 금액

일부 PG사의 경우 상점아이디의 과세/면세별로 구분을 두지 않고 하나의 상점아이디를 사용하여 `tax_free` 속성으로 면세 금액을 설정하는 경우도 있습니다.

<div class="hint" data-style="info">

**상점아이디**

각 PG사 별로 가입신청 및 계약 완료 이후 발급되는 상점아이디 명칭은 PG사 별로 다릅니다.
예를 들어, KG이니시스는 `상점 아이디(MID)`, 카카오페이는 `고객사 코드(CID)`, 그리고 네이버페이는 `파트너 ID`를 발급받습니다.

</div>

면세 기준에 따라 발급받는 상점아이디는 다음 3가지 유형이 있습니다.

> **면세 상점아이디**
>
> 면세 상품만 판매하는 사업자의 경우 면세 상점아이디를 발급 받습니다.
> 면세 상점아이디로 거래를 하면, `tax_free` 속성은 무시되고 모든 결제 건은 일괄 면세 처리 됩니다.

> **과세 상점아이디**
>
> 과세 상품만 판매하는 사업자의 경우 과세 상점아이디를 발급 받습니다.
> 과세 상점아이디로 거래를 하면, `tax_free` 속성은 무시되고 모든 결제 건은 일괄 과세 처리 됩니다.

> **복합과세 상점아이디**
>
> 과세상품과 면세상품을 함께 판매하는 사업자의 경우 판매되는 상품에 따라 면세 금액액이 달라질 수
> 있으므로, 반드시 복합 과제 상점아이디를 발급 받아야 합니다.
>
> 과세상품과 면세상품을 함께 구매하는 경우에는, `amount` 속성에 **총 결제 금액**을 지정하고
> `tax_free` 속성에는 구매하는 상품 중 **면세상품의 금액 합계**를 지정합니다.

<div class="hint" data-style="warning">

**`tax_free` 속성은 필수 입력**

복합 과세 상점아이디 거래건의 경우 **반드시 `amount` 속성과 `tax_free` 속성을 함께 설정해야** 합니다.
일부 PG사의 경우 `tax_free` 값이 누락되면 결제창 호출 단계에서 오류가 발생할 수 있습니다.

특히 KG이니시스의 경우 **모든 결제건을 일괄 면세 처리**하고 있으며 과세 상점 아이디를 사용하다가 중간에 복합 과세 상점 아이디로 변경하면 기존에 과세 결제건을 모두 일괄 면세로 변경하고 있으니 이용에 주의하시길 바랍니다.

</div>

## 상황별 tax\_free 속성 적용하기 <a href="#taxfree" id="taxfree" />

고객이 과세상품과 면세상품을 동시에 구매하는 상황을 가정하여 각각의 시나리오별로 `amount`와 `tax_free`속성을 다음과 같이 설정합니다.
다음은 한 화훼 사업자(부가세 면세사업자)가 식물 모종과 화병을 판매하는 예제입니다.

- 식물 모종: **부가세 면세 상품**, 모종 당 11,000원
- 화병: **부가세 과세 상품**, 병당 22,000원

### CASE 01. 고객이 모종(면세 상품)만 구매하는 경우

고객이 11,000원짜리 모종 1단을 구매할 때 총 결제 금액은 11,000원이며 그 중 면세항목 상품의 금액 합계는 11,000원이므로 다음과 같이 설정합니다.

```ts title="JavaScript"
IMP.request_pay(
  {
    amount: 11000, // 결제금액
    tax_free: 11000, // 면세공급가액
    // ...
  },
  function (rsp) {
    // ...
  },
);
```

위와같이 결제 속성을 지정하면 11,000원 전액이 면세적용되며 발급되는 매출전표에는 다음과 같은 내용을 확인할 수 있습니다.
(_PG사에 따라 용어가 다를 수 있습니다_)

- 면세 공급가액 : 11,000원
- 부가가치세 : 0원

### CASE 02. 고객이 화병(과세 상품)만 구매하는 경우

고객이 22,000원짜리 화병 1병을 구매할 때 총 결제 금액은 22,000원이며 그 중 면세항목 상품의 금액 합계는 0원이므로 다음과 같이 설정합니다.

```ts title="JavaScript"
IMP.request_pay(
  {
    amount: 22000, // 결제금액
    tax_free: 0, // 면세공급가액
    // ...
  },
  function (rsp) {
    // ...
  },
);
```

위와같이 결제 속성을 지정하면 22,000원에 대해 10%의 부가가치세가 적용되며, 발급되는 매출전표에는 다음과 같은 내용을 확인할 수 있습니다.

- 일반공급가액 : 20,000원
- 부가가치세 : 2,000원

### CASE 03. 고객이 모종과 화병을 동시(면세 및 과세 상품)에 구매하는 경우

고객이 모종 3단과 화병 1병을 구매할 때 총 결제 금액은 55,000원(33,000원 + 22,000원)이며 그 중
면세항목 상품의 금액 합계는 33,000원(모종 3단의 금액 합계)이므로 다음과 같이 설정합니다.

```ts title="JavaScript"
IMP.request_pay(
  {
    amount: 55000, // 결제금액
    tax_free: 33000, // 면세공급가액
    // ...
  },
  function (rsp) {
    // ...
  },
);
```

위와같이 결제 속성을 지정하면 55,000원 중 22,000원(과세금액)에 대해 10%의 부가가치세가 적용되며
33,000원에 대해 면세적용되어 발급되는 매출전표에는 다음과 같은 내용을 확인할 수 있습니다.

- 일반공급가액 : 20,000원
- 면세공급가액 : 33,000원
- 부가가치세 : 2,000원
